<?php
header('Content-Type: application/json');  // Norādām, ka atbilde būs JSON formātā

$servername = "localhost";  // Datubāzes servera nosaukums
$username = "root";         // Datubāzes lietotājvārds
$password = "";             // Datubāzes parole
$dbname = "eraecho";        // Datubāzes nosaukums

// Savienojamies ar datubāzi, izmantojot MySQLi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbaudām, vai savienojums ir veiksmīgs
if ($conn->connect_error) {
    http_response_code(500);  // Ja savienojums neizdodas, atgriežam kļūdas statusu
    echo json_encode(['message' => 'Connection failed: ' . $conn->connect_error]); // Atgriežam kļūdu JSON formātā
    exit;
}

// Pārbaudām, vai pieprasījums ir POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Saņemam datus no formas
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirm_password'];

    // Validējam lietotājvārdu (vismaz 3 rakstzīmes)
    if (empty($username) || strlen($username) < 3) {
        http_response_code(400);  // Ja lietotājvārds ir īss, atgriežam kļūdu
        echo json_encode(['message' => 'Username must be at least 3 characters long.']);
        exit;
    }

    // Validējam paroles saskaņošanu
    if ($password !== $confirmPassword) {
        http_response_code(400);  // Ja parolēm nav sakritības, atgriežam kļūdu
        echo json_encode(['message' => 'Passwords do not match.']);
        exit;
    }

    // Validējam e-pasta formātu
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);  // Ja e-pasts nav pareizā formātā, atgriežam kļūdu
        echo json_encode(['message' => 'Invalid email format.']);
        exit;
    }

    // Pārbaudām, vai e-pasts jau nav reģistrēts
    $checkEmailQuery = "SELECT * FROM users WHERE email = ?";
    $stmt = $conn->prepare($checkEmailQuery);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        http_response_code(409);  // Ja e-pasts jau ir reģistrēts, atgriežam konfliktu
        echo json_encode(['message' => 'Email is already registered.']);
        exit;
    }

    // Šifrējam paroli, izmantojot bcrypt
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    // Sagatavojam SQL vaicājumu, lai ievadītu lietotāju datubāzē
    $insertQuery = "INSERT INTO users (username, email, password) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($insertQuery);
    $stmt->bind_param("sss", $username, $email, $hashedPassword);

    // Izpildām vaicājumu un pārbaudām rezultātu
    if ($stmt->execute()) {
        http_response_code(201);  // Ja lietotājs veiksmīgi reģistrēts, atgriežam veiksmīgu atbildi
        echo json_encode(['message' => 'Registration successful!']);
    } else {
        http_response_code(500);  // Ja ir kļūda, atgriežam kļūdas ziņojumu
        echo json_encode(['message' => 'An error occurred: ' . $stmt->error]);
    }

    // Aizveram sagatavoto vaicājumu un datubāzes savienojumu
    $stmt->close();
    $conn->close();
} else {
    http_response_code(405);  // Ja pieprasījums nav POST, atgriežam neļautas metodes kļūdu
    echo json_encode(['message' => 'Method not allowed.']);
}
?>
